/***************************************
*                                      *
*          b̃Cvbg          *
*                                      *
*                                      *
***************************************/

#include <iostream>
#include <cstdlib>
#include "snaps.h"
#include "kisosu.h"
#include "file_open.h"
#include "cntl.h"

// b
#define KISOSUM1      "/rev26/nat/kisosu/1gou/1m-23-3.csv"
#define KISOSUM3      "/rev26/nat/kisosu/3gou/3m-23.csv"
#define KISOSUF1      "/rev26/nat/kisosu/1gou/1f-23-3.csv"
#define KISOSUF3      "/rev26/nat/kisosu/3gou/3f-23.csv"

void readkisosu_error( int shurui );


void dtst( int shubetu ) 
{
	int nenrei;
	int counter;
	int data_number;
	int member;
	int jukyu_nenrei;
	int tokyu;
	int kikan;
	int dankai;
	int kokko;
	int kubun;
	double buffer[53];
	char filename[250];
	
	using namespace std;
	
	// b̓ǂݍ
	switch( shubetu )
	{
		case 2:
			sprintf( filename , KISOSUM1 );
			break;
		case 3 :
			sprintf( filename , KISOSUM3 );
			break;
		case 5 :
			sprintf( filename , KISOSUF1 );
			break;
		case 6 :
			sprintf( filename , KISOSUF3 );
			break;
		default :
			cout << "wOshubetu " << shubetu << " ǂݍ݂܂" << endl;
			exit(1);
	}
	
	if( ( fp_kisosu = fopen( filename , "r" ) ) == NULL )
	{
		cout << "bt@C " << shubetu << " ̃I[vɎs܂" << endl;
		exit(1);
	}
	
	read_headder( fp_kisosu );
	
	fprintf( fp_settei , "bt@C %s\n" , filename );
	
	// یҁEҊ҂̓Ǎp
	if( shubetu == 2 || shubetu == 5 )
	{
		kubun = 14;
	}
	else
	{
		kubun = 3;
	}
	
	// PDی
	for( nenrei = MIN_HIHO_NENREI ; nenrei <= MAX_HIHO_NENREI ; nenrei++ )
	{
		for( kikan = 0 ; kikan <= MAX_HIHO_KIKAN ; kikan++ )
		{
			Hihokensha[nenrei - MIN_HIHO_NENREI][kikan].ninzu = 0.;
			Hihokensha[nenrei - MIN_HIHO_NENREI][kikan].kikan = 0.;
			Hihokensha[nenrei - MIN_HIHO_NENREI][kikan].noufu = 0.;
			Hihokensha_Y[nenrei - MIN_HIHO_NENREI][kikan].ninzu = 0.;
			Hihokensha_Y[nenrei - MIN_HIHO_NENREI][kikan].kikan = 0.;
			Hihokensha_Y[nenrei - MIN_HIHO_NENREI][kikan].noufu = 0.;
			Hihokensha2[nenrei - MIN_HIHO_NENREI][kikan].ninzu = 0.;
			Hihokensha2[nenrei - MIN_HIHO_NENREI][kikan].kikan = 0.;
			Hihokensha2[nenrei - MIN_HIHO_NENREI][kikan].noufu = 0.;
			for( dankai = 0 ; dankai <= MAX_MENJO - 1 ; dankai++ )
			{
				for( kokko = 0 ; kokko <= KOKKO_HIKIAGE - 1 ; kokko++ )
				{
					Hihokensha[nenrei - MIN_HIHO_NENREI][kikan].menjo[dankai][kokko] = 0.;
					Hihokensha_Y[nenrei - MIN_HIHO_NENREI][kikan].menjo[dankai][kokko] = 0.;
					Hihokensha2[nenrei - MIN_HIHO_NENREI][kikan].menjo[dankai][kokko] = 0.;
				}
			}
			Hihokensha[nenrei - MIN_HIHO_NENREI][kikan].gakusei = 0.;
			Hihokensha[nenrei - MIN_HIHO_NENREI][kikan].wakamono = 0.;
			Hihokensha[nenrei - MIN_HIHO_NENREI][kikan].fuka = 0.;
			Hihokensha_Y[nenrei - MIN_HIHO_NENREI][kikan].gakusei = 0.;
			Hihokensha_Y[nenrei - MIN_HIHO_NENREI][kikan].wakamono = 0.;
			Hihokensha_Y[nenrei - MIN_HIHO_NENREI][kikan].fuka = 0.;
			Hihokensha2[nenrei - MIN_HIHO_NENREI][kikan].gakusei = 0.;
			Hihokensha2[nenrei - MIN_HIHO_NENREI][kikan].wakamono = 0.;
			Hihokensha2[nenrei - MIN_HIHO_NENREI][kikan].fuka = 0.;
		}
	}
	
	for( member = 1 ; member <= kubun ; member++ )
	{
		for( nenrei = MIN_HIHO_NENREI ; nenrei <= MAX_HIHO_NENREI - 1 ; nenrei++ )
		{
			if( read_data( buffer , fp_kisosu , &data_number ) != EOF )
			{
				if( buffer[0] != 1 || buffer[1] != member )
				{
					cout << "ی҂̓ǍɍsĂ܂ " << buffer[0] << " " << buffer[1] << " " << member << " " << nenrei << endl;
					exit( 1 );
				}
				else
				{
					for( counter = 0 ; counter <= MAX_HIHO_KIKAN - 1 ; counter++ )
					{
						switch( member )
						{
							case 1 :
								Hihokensha[nenrei - MIN_HIHO_NENREI][counter].ninzu = buffer[counter + 3];
								Hihokensha_Y[nenrei - MIN_HIHO_NENREI][counter].ninzu = buffer[counter + 3];
								break;
							case 2 :
								Hihokensha[nenrei - MIN_HIHO_NENREI][counter].kikan = buffer[counter + 3] / 12.;
								break;
							case 3 :
								Hihokensha[nenrei - MIN_HIHO_NENREI][counter].noufu = buffer[counter + 3] / 12.;
								break;
							case 4 :
								Hihokensha[nenrei - MIN_HIHO_NENREI][counter].menjo[ZENGAKU][1] = buffer[counter + 3] / 12.;
								break;
							case 5 :
								Hihokensha[nenrei - MIN_HIHO_NENREI][counter].menjo[MENJO_3_4][1] = buffer[counter + 3] / 12.;
								break;
							case 6 :
								Hihokensha[nenrei - MIN_HIHO_NENREI][counter].menjo[MENJO_1_2][1] = buffer[counter + 3] / 12.;
								break;
							case 7 :
								Hihokensha[nenrei - MIN_HIHO_NENREI][counter].menjo[MENJO_1_4][1] = buffer[counter + 3] / 12.;
								break;
							case 8 :
								Hihokensha[nenrei - MIN_HIHO_NENREI][counter].gakusei = buffer[counter + 3] / 12.;
								break;
							case 9 :
								Hihokensha[nenrei - MIN_HIHO_NENREI][counter].wakamono = buffer[counter + 3] / 12.;
								break;
							case 10 :
								Hihokensha[nenrei - MIN_HIHO_NENREI][counter].fuka = buffer[counter + 3] / 12.;
								break;
							case 11 :
								Hihokensha[nenrei - MIN_HIHO_NENREI][counter].menjo[ZENGAKU][2] = buffer[counter + 3] / 12.;
								break;
							case 12 :
								Hihokensha[nenrei - MIN_HIHO_NENREI][counter].menjo[MENJO_3_4][2] = buffer[counter + 3] / 12.;
								break;
							case 13 :
								Hihokensha[nenrei - MIN_HIHO_NENREI][counter].menjo[MENJO_1_2][2] = buffer[counter + 3] / 12.;
								break;
							case 14 :
								Hihokensha[nenrei - MIN_HIHO_NENREI][counter].menjo[MENJO_1_4][2] = buffer[counter + 3] / 12.;
								break;
						}
					}
				}
			}
			else
			{
				readkisosu_error( 1 );
			}
		}
	}
	
	// QDҊ
	for( nenrei = MIN_HIHO_NENREI ; nenrei <= MAX_HIHO_NENREI ; nenrei++ )
	{
		for( kikan = 0 ; kikan <= MAX_HIHO_KIKAN ; kikan++ )
		{
			Taikisha[nenrei - MIN_HIHO_NENREI][kikan].ninzu = 0.;
			Taikisha[nenrei - MIN_HIHO_NENREI][kikan].kikan = 0.;
			Taikisha[nenrei - MIN_HIHO_NENREI][kikan].noufu = 0.;
			Taikisha_Y[nenrei - MIN_HIHO_NENREI][kikan].ninzu = 0.;
			Taikisha_Y[nenrei - MIN_HIHO_NENREI][kikan].kikan = 0.;
			Taikisha_Y[nenrei - MIN_HIHO_NENREI][kikan].noufu = 0.;
			Taikisha2[nenrei - MIN_HIHO_NENREI][kikan].ninzu = 0.;
			Taikisha2[nenrei - MIN_HIHO_NENREI][kikan].kikan = 0.;
			Taikisha2[nenrei - MIN_HIHO_NENREI][kikan].noufu = 0.;
			for( dankai = 0 ; dankai <= MAX_MENJO - 1 ; dankai++ )
			{
				for( kokko = 0 ; kokko <= KOKKO_HIKIAGE - 1 ; kokko++ )
				{
					Taikisha[nenrei - MIN_HIHO_NENREI][kikan].menjo[dankai][kokko] = 0.;
					Taikisha_Y[nenrei - MIN_HIHO_NENREI][kikan].menjo[dankai][kokko] = 0.;
					Taikisha2[nenrei - MIN_HIHO_NENREI][kikan].menjo[dankai][kokko] = 0.;
				}
			}
			Taikisha[nenrei - MIN_HIHO_NENREI][kikan].gakusei = 0.;
			Taikisha[nenrei - MIN_HIHO_NENREI][kikan].wakamono = 0.;
			Taikisha[nenrei - MIN_HIHO_NENREI][kikan].fuka = 0.;
			Taikisha_Y[nenrei - MIN_HIHO_NENREI][kikan].gakusei = 0.;
			Taikisha_Y[nenrei - MIN_HIHO_NENREI][kikan].wakamono = 0.;
			Taikisha_Y[nenrei - MIN_HIHO_NENREI][kikan].fuka = 0.;
			Taikisha2[nenrei - MIN_HIHO_NENREI][kikan].gakusei = 0.;
			Taikisha2[nenrei - MIN_HIHO_NENREI][kikan].wakamono = 0.;
			Taikisha2[nenrei - MIN_HIHO_NENREI][kikan].fuka = 0.;
		}
	}
	
	for( member = 1 ; member <= kubun ; member++ )
	{
		for( nenrei = MIN_HIHO_NENREI ; nenrei <= MAX_HIHO_NENREI - 1 ; nenrei++ )
		{
			if( read_data( buffer , fp_kisosu , &data_number ) != EOF )
			{
				if( buffer[0] != 2 || buffer[1] != member )
				{
					cout << "Ҋ҂̓ǍɍsĂ܂ " << buffer[0] << " " << buffer[1] << endl;
					exit( 1 );
				}
				else
				{
					for( counter = 0 ; counter <= MAX_HIHO_KIKAN - 1 ; counter++ )
					{
						switch( member )
						{
							case 1 :
								Taikisha[nenrei - MIN_HIHO_NENREI][counter].ninzu = buffer[counter + 3];
								Taikisha_Y[nenrei - MIN_HIHO_NENREI][counter].ninzu = buffer[counter + 3];
								break;
							case 2 :
								Taikisha[nenrei - MIN_HIHO_NENREI][counter].kikan = buffer[counter + 3] / 12.;
								break;
							case 3 :
								Taikisha[nenrei - MIN_HIHO_NENREI][counter].noufu = buffer[counter + 3] / 12.;
								break;
							case 4 :
								Taikisha[nenrei - MIN_HIHO_NENREI][counter].menjo[ZENGAKU][1] = buffer[counter + 3] / 12.;
								break;
							case 5 :
								Taikisha[nenrei - MIN_HIHO_NENREI][counter].menjo[MENJO_3_4][1] = buffer[counter + 3] / 12.;
								break;
							case 6 :
								Taikisha[nenrei - MIN_HIHO_NENREI][counter].menjo[MENJO_1_2][1] = buffer[counter + 3] / 12.;
								break;
							case 7 :
								Taikisha[nenrei - MIN_HIHO_NENREI][counter].menjo[MENJO_1_4][1] = buffer[counter + 3] / 12.;
								break;
							case 8 :
								Taikisha[nenrei - MIN_HIHO_NENREI][counter].gakusei = buffer[counter + 3] / 12.;
								break;
							case 9 :
								Taikisha[nenrei - MIN_HIHO_NENREI][counter].wakamono = buffer[counter + 3] / 12.;
								break;
							case 10 :
								Taikisha[nenrei - MIN_HIHO_NENREI][counter].fuka = buffer[counter + 3] / 12.;
								break;
							case 11 :
								Taikisha[nenrei - MIN_HIHO_NENREI][counter].menjo[ZENGAKU][2] = buffer[counter + 3] / 12.;
								break;
							case 12 :
								Taikisha[nenrei - MIN_HIHO_NENREI][counter].menjo[MENJO_3_4][2] = buffer[counter + 3] / 12.;
								break;
							case 13 :
								Taikisha[nenrei - MIN_HIHO_NENREI][counter].menjo[MENJO_1_2][2] = buffer[counter + 3] / 12.;
								break;
							case 14 :
								Taikisha[nenrei - MIN_HIHO_NENREI][counter].menjo[MENJO_1_4][2] = buffer[counter + 3] / 12.;
								break;
						}
					}
				}
			}
			else
			{
				readkisosu_error( 2 );
			}
		}
	}
	
	// RDVbN
 	for( nenrei = MIN_ROREI_JUKYU ; nenrei <= MAX_ROREI_JUKYU ; nenrei++ )
	{
		for( jukyu_nenrei = MIN_ROREI_JUKYU ; jukyu_nenrei <= 70 ; jukyu_nenrei++ )
		{
			Rorei_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].ninzu = 0.;
			Rorei_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].noufu = 0.;
			for( dankai = 0 ; dankai <= MAX_MENJO - 1 ; dankai++ )
			{
				for( kokko = 0 ; kokko <= KOKKO_HIKIAGE - 1 ; kokko++ )
				{
					Rorei_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].menjo[dankai][kokko] = 0.;
				}
			}
			Rorei_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].rofuku_shitasasae = 0.;
			Rorei_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].fuka = 0.;
		}
	}
	
	if( shubetu == 2 || shubetu == 5 )
	{
		for( member = 1 ; member <= 12 ; member++ )
		{
			for( nenrei = MIN_ROREI_JUKYU ; nenrei <= MAX_ROREI_JUKYU ; nenrei++ )
			{
				if( read_data( buffer , fp_kisosu , &data_number ) != EOF )
				{
					if( buffer[0] != 3 || buffer[1] != member )
					{
						cout << "VbN̓ǍɍsĂ܂ " << buffer[0] << " " << buffer[1] << " " << member << " " << buffer[3] <<  endl;
						exit( 1 );
					}
					else
					{
						for( counter = 0 ; counter <= 10 ; counter++ )
						{
							switch( member )
							{
								case 1 :
									Rorei_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].ninzu = buffer[counter + 3];
									break;
								case 2 :
									Rorei_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].noufu = buffer[counter + 3];
									break;
								case 3 :
									Rorei_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].menjo[ZENGAKU][1] = buffer[counter + 3];
 									break;
								case 4 :
									Rorei_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].menjo[MENJO_3_4][1] = buffer[counter + 3];
 									break;
								case 5 :
									Rorei_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].menjo[MENJO_1_2][1] = buffer[counter + 3];
 									break;
								case 6 :
									Rorei_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].menjo[MENJO_1_4][1] = buffer[counter + 3];
 									break;
								case 7 :
									Rorei_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].rofuku_shitasasae = buffer[counter + 3];
									break;
								case 8 :
									Rorei_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].fuka = buffer[counter + 3];
									break;
								case 9 :
									Rorei_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].menjo[ZENGAKU][2] = buffer[counter + 3];
 									break;
								case 10 :
									Rorei_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].menjo[MENJO_3_4][2] = buffer[counter + 3];
 									break;
								case 11 :
									Rorei_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].menjo[MENJO_1_2][2] = buffer[counter + 3];
 									break;
								case 12 :
									Rorei_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].menjo[MENJO_1_4][2] = buffer[counter + 3];
 									break;
							}
						}
					}
				}
				else
				{
					readkisosu_error( 3 );
				}
			}
		}
	}
	else if( shubetu == 3 || shubetu == 6 )
	{
		for( nenrei = MIN_ROREI_JUKYU ; nenrei <= MAX_ROREI_JUKYU ; nenrei++ )
		{
			if( read_data( buffer , fp_kisosu , &data_number ) != EOF )
			{
				if( buffer[0] != 3 || buffer[1] != 2 )
				{
					cout << "VbN̓ǍɍsĂ܂ " << buffer[0] << " " << buffer[1] << " " << member << " " << buffer[3] <<  endl;
					exit( 1 );
				}
				else
				{
					for( counter = 0 ; counter <= 10 ; counter++ )
					{
						Rorei_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].noufu = buffer[counter + 3];
					}
				}
			}
			else
			{
				readkisosu_error( 3 );
			}
		}
	}
	
	// SD@V
	for( nenrei = MIN_ROREI_JUKYU ; nenrei <= MAX_ROREI_JUKYU ; nenrei++ )
	{
		for( jukyu_nenrei = MIN_ROREI_JUKYU ; jukyu_nenrei <= 70 ; jukyu_nenrei++ )
		{
			Rorei_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].ninzu = 0.;
			Rorei_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].noufu = 0.;
			Rorei_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].menjo = 0.;
			Rorei_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].kasa_noufu = 0.;
			Rorei_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].kasa_menjo = 0.;
			Rorei_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].rofuku_shitasasae = 0.;
			Rorei_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].fuka = 0.;
		}
	}
	
	if( shubetu == 2 || shubetu == 5 )
	{
		for( member = 1 ; member <= 7 ; member++ )
		{
			for( nenrei = MIN_ROREI_JUKYU ; nenrei <= MAX_ROREI_JUKYU ; nenrei++ )
			{
				if( read_data( buffer , fp_kisosu , &data_number ) != EOF )
				{
					if( buffer[0] != 4 || buffer[1] != member )
					{
						cout << "@V̓ǍɍsĂ܂ " << buffer[0] << " " << buffer[1] << endl;
						exit( 1 );
					}
					else
					{
						for( counter = 0 ; counter <= 10 ; counter++ )
						{
							switch( member )
							{
								case 1 :
									Rorei_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].ninzu = buffer[counter + 3];
									break;
								case 2 :
									Rorei_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].noufu = buffer[counter + 3];
									break;
								case 3 :
									Rorei_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].menjo = buffer[counter + 3];
									break;
								case 4 :
									Rorei_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].kasa_noufu = buffer[counter + 3];
									break;
								case 5 :
									Rorei_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].kasa_menjo = buffer[counter + 3];
									break;
								case 6 :
									Rorei_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].rofuku_shitasasae = buffer[counter + 3];
									break;
								case 7 :
									Rorei_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].fuka = buffer[counter + 3];
									break;
							}
						}
					}
				}
				else
				{
					readkisosu_error( 4 );
				}
			}
		}
	}
	
	// TD@ʘV
	for( nenrei = MIN_ROREI_JUKYU ; nenrei <= MAX_ROREI_JUKYU ; nenrei++ )
	{
		for( jukyu_nenrei = MIN_ROREI_JUKYU ; jukyu_nenrei <= 70 ; jukyu_nenrei++ )
		{
			Turo_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].ninzu = 0.;
			Turo_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].noufu = 0.;
			Turo_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].menjo = 0.;
			Turo_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].kasa_noufu = 0.;
			Turo_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].kasa_menjo = 0.;
			Turo_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].rofuku_shitasasae = 0.;
			Turo_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].fuka = 0.;
		}
	}
	
	if( shubetu == 2 || shubetu == 5 )
	{
		for( member = 1 ; member <= 7 ; member++ )
		{
			for( nenrei = MIN_ROREI_JUKYU ; nenrei <= MAX_ROREI_JUKYU ; nenrei++ )
			{
				if( read_data( buffer , fp_kisosu , &data_number ) != EOF )
				{
					if( buffer[0] != 5 || buffer[1] != member )
					{
						cout << "@ʘV̓ǍɍsĂ܂ " << buffer[0] << " " << buffer[1] << endl;
						exit( 1 );
					}
					else
					{
						for( counter = 0 ; counter <= 5 ; counter++ )
						{
							switch( member )
							{
								case 1 :
									Turo_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].ninzu = buffer[counter + 3];
									break;
								case 2 :
									Turo_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].noufu = buffer[counter + 3];
									break;
								case 3 :
									Turo_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].menjo = buffer[counter + 3];
									break;
								case 4 :
									Turo_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].kasa_noufu = buffer[counter + 3];
									break;
								case 5 :
									Turo_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].kasa_menjo = buffer[counter + 3];
									break;
								case 6 :
									Turo_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].rofuku_shitasasae = buffer[counter + 3];
									break;
								case 7 :
									Turo_Kyu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].fuka = buffer[counter + 3];
									break;
							}
						}
					}
				}
				else
				{
					readkisosu_error( 5 );
				}
			}
		}
	}
	
	// UDTNN
 	for( nenrei = MIN_ROREI_JUKYU ; nenrei <= MAX_ROREI_JUKYU ; nenrei++ )
	{
		for( jukyu_nenrei = MIN_ROREI_JUKYU ; jukyu_nenrei <= 70 ; jukyu_nenrei++ )
		{
 			Gonen_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].ninzu = 0.;
			Gonen_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].noufu = 0.;
		}
	}
	
	if( shubetu == 2 || shubetu == 5 )
	{
		for( nenrei = MIN_ROREI_JUKYU ; nenrei <= MAX_ROREI_JUKYU ; nenrei++ )
		{
			if( read_data( buffer , fp_kisosu , &data_number ) != EOF )
			{
				if( buffer[0] != 6 )
				{
					cout << "TNN̓ǍɍsĂ܂ " << buffer[0] << endl;
					exit( 1 );
				}
				else
				{
					Gonen_Nendomatu[nenrei - MIN_ROREI_JUKYU][65 - MIN_ROREI_JUKYU].ninzu = buffer[3];
					Gonen_Nendomatu[nenrei - MIN_ROREI_JUKYU][65 - MIN_ROREI_JUKYU].noufu = buffer[4];
				}
			}
			else
			{
				readkisosu_error( 6 );
			}
		}
	}
	
	// VDQbiʁj
	for( nenrei = MIN_SHOGAI_JUKYU ; nenrei <= MAX_SHOGAI_JUKYU ; nenrei++ )
	{
		for( tokyu = 0 ; tokyu <= 2 ; tokyu++ )
		{
			Shogai_Ippan_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][tokyu].ninzu = 0.;
			Shogai_Ippan_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][tokyu].kihon = 0.;
			Shogai_Ippan_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][tokyu].kakyu = 0.;
			Shogai_Ippan_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][tokyu].menjo_kihon = 0.;
			Shogai_Ippan_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][tokyu].menjo_kakyu = 0.;
		}
	}
	
	if( shubetu == 2 || shubetu == 5 )
	{
		for( nenrei = MIN_SHOGAI_JUKYU ; nenrei <= MAX_SHOGAI_JUKYU ; nenrei++ )
		{
			if( read_data( buffer , fp_kisosu , &data_number ) != EOF )
			{
				if( buffer[0] != 7 )
				{
					cout << "QbiʁjǍɍsĂ܂ " << buffer[0] << endl;
					exit( 1 );
				}
				else
				{
					for( counter = 0 ; counter <= 5 ; counter++ )
					{
						switch( counter % 3 )
						{
							case 0 :
								Shogai_Ippan_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][counter / 3 + 1].ninzu = buffer[counter + 3];
								break;
							case 1 :
								Shogai_Ippan_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][counter / 3 + 1].kihon = buffer[counter + 3];
								break;
							case 2 :
								Shogai_Ippan_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][counter / 3 + 1].kakyu = buffer[counter + 3];
								break;
						}
					}
				}
			}
			else
			{
				readkisosu_error( 7 );
			}
		}
	}
	
	// WDQbiQOΑOj
	for( nenrei = MIN_SHOGAI_JUKYU ; nenrei <= MAX_SHOGAI_JUKYU ; nenrei++ )
	{
		for( tokyu = 0 ; tokyu <= 2 ; tokyu++ )
		{
			Shogai_20mae_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][tokyu].ninzu = 0.;
			Shogai_20mae_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][tokyu].kihon = 0.;
			Shogai_20mae_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][tokyu].kakyu = 0.;
			Shogai_20mae_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][tokyu].menjo_kihon = 0.;
			Shogai_20mae_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][tokyu].menjo_kakyu = 0.;
		}
	}
	
	if( shubetu == 2 || shubetu == 5 )
	{
		for( nenrei = MIN_SHOGAI_JUKYU ; nenrei <= MAX_SHOGAI_JUKYU ; nenrei++ )
		{
			if( read_data( buffer , fp_kisosu , &data_number ) != EOF )
			{
				if( buffer[0] != 8 )
				{
					cout << "QbiQOΑOj̓ǍɍsĂ܂ " << buffer[0] << endl;
					exit( 1 );
				}
				else
				{
					for( counter = 0 ; counter <= 5 ; counter++ )
					{
						switch( counter % 3 )
						{
							case 0 :
								Shogai_20mae_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][counter / 3 + 1].ninzu = buffer[counter + 3];
								break;
							case 1 :
								Shogai_20mae_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][counter / 3 + 1].kihon = buffer[counter + 3];
								break;
							case 2 :
								Shogai_20mae_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][counter / 3 + 1].kakyu = buffer[counter + 3];
								break;
						}
					}
				}
			}
			else
			{
				readkisosu_error( 8 );
			}
		}
	}
	
	// XD@Q
	for( nenrei = MIN_SHOGAI_JUKYU ; nenrei <= MAX_SHOGAI_JUKYU ; nenrei++ )
	{
		for( tokyu = 0 ; tokyu <= 2 ; tokyu++ )
		{
			Shogai_Kyu_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][tokyu].ninzu = 0.;
			Shogai_Kyu_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][tokyu].kihon = 0.;
			Shogai_Kyu_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][tokyu].kakyu = 0.;
			Shogai_Kyu_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][tokyu].menjo_kihon = 0.;
			Shogai_Kyu_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][tokyu].menjo_kakyu = 0.;
		}
	}
	
	if( shubetu == 2 || shubetu == 5 )
	{
		for( nenrei = MIN_SHOGAI_JUKYU ; nenrei <= MAX_SHOGAI_JUKYU ; nenrei++ )
		{
			if( read_data( buffer , fp_kisosu , &data_number ) != EOF )
			{
				if( buffer[0] != 9 )
				{
					cout << "@Q̓ǍɍsĂ܂ " << buffer[0]  << endl;
					exit( 1 );
				}
				else
				{
					for( counter = 0 ; counter <= 9 ; counter++ )
					{
						switch( counter % 5 )
						{
							case 0 :
								Shogai_Kyu_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][counter / 5 + 1].ninzu = buffer[counter + 3];
								break;
							case 1 :
								Shogai_Kyu_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][counter / 5 + 1].kihon = buffer[counter + 3];
								break;
							case 2 :
								Shogai_Kyu_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][counter / 5 + 1].kakyu = buffer[counter + 3];
								break;
							case 3 :
								Shogai_Kyu_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][counter / 5 + 1].menjo_kihon = buffer[counter + 3];
							break;
							case 4 :
								Shogai_Kyu_Nendomatu[nenrei - MIN_SHOGAI_JUKYU][counter / 5 + 1].menjo_kakyu = buffer[counter + 3];
								break;
						}
					}
				}
			}
			else
			{
				readkisosu_error( 9 );
			}
		}
	}
	
	// POD⑰iȁj
	for( nenrei = MIN_IZOKU_TUMA_JUKYU ; nenrei <= MAX_IZOKU_TUMA_JUKYU ; nenrei++ )
	{
		Izoku_Tuma_Nendomatu[nenrei - MIN_IZOKU_TUMA_JUKYU].ninzu = 0.;
		Izoku_Tuma_Nendomatu[nenrei - MIN_IZOKU_TUMA_JUKYU].kihon = 0.;
		Izoku_Tuma_Nendomatu[nenrei - MIN_IZOKU_TUMA_JUKYU].kakyu = 0.;
	}
	
	if( shubetu == 2 )
	{
		for( nenrei = MIN_IZOKU_TUMA_JUKYU ; nenrei <= MAX_IZOKU_TUMA_JUKYU ; nenrei++ )
		{
			if( read_data( buffer , fp_kisosu , &data_number ) != EOF )
			{
				if( buffer[0] != 10 )
				{
					cout << "⑰iȁj̓ǍɍsĂ܂ " << buffer[0] << endl;
					exit( 1 );
				}
				else
				{
					for( counter = 0 ; counter <= 2 ; counter++ )
					{
						switch( counter )
						{
							case 0 :
								Izoku_Tuma_Nendomatu[nenrei- MIN_IZOKU_TUMA_JUKYU].ninzu = buffer[counter + 3];
								break;
							case 1 :
								Izoku_Tuma_Nendomatu[nenrei- MIN_IZOKU_TUMA_JUKYU].kihon = buffer[counter + 3];
								break;
							case 2 :
								Izoku_Tuma_Nendomatu[nenrei- MIN_IZOKU_TUMA_JUKYU].kakyu = buffer[counter + 3];
								break;
						}
					}
				}
			}
			else
			{
				readkisosu_error( 10 );
			}
		}
	}
	
	// POfD⑰ivj
	for( nenrei = MIN_IZOKU_OTTO_JUKYU ; nenrei <= MAX_IZOKU_OTTO_JUKYU ; nenrei++ )
	{
		Izoku_Otto_Nendomatu[nenrei - MIN_IZOKU_OTTO_JUKYU].ninzu = 0.;
		Izoku_Otto_Nendomatu[nenrei - MIN_IZOKU_OTTO_JUKYU].kihon = 0.;
		Izoku_Otto_Nendomatu[nenrei - MIN_IZOKU_OTTO_JUKYU].kakyu = 0.;
	}
	
	// PPD⑰iqj
	for( nenrei = MIN_IZOKU_KO_JUKYU ; nenrei <= MAX_IZOKU_KO_JUKYU ; nenrei++ )
	{
		Izoku_Ko_Nendomatu[nenrei - MIN_IZOKU_KO_JUKYU].ninzu = 0.;
		Izoku_Ko_Nendomatu[nenrei - MIN_IZOKU_KO_JUKYU].kihon = 0.;
		Izoku_Ko_Nendomatu[nenrei - MIN_IZOKU_KO_JUKYU].kakyu = 0.;
	}
	
	if( shubetu == 2 )
	{
		for( nenrei = MIN_IZOKU_KO_JUKYU ; nenrei <= MAX_IZOKU_KO_JUKYU ; nenrei++ )
		{
			if( read_data( buffer , fp_kisosu , &data_number ) != EOF )
			{
				if( buffer[0] != 11 )
				{
					cout << "⑰iqj̓ǍɍsĂ܂ " << buffer[0] << endl;
					exit( 1 );
				}
				else
				{
					for( counter = 0 ; counter <= 2 ; counter++ )
					{
						switch( counter )
						{
							case 0 :
								Izoku_Ko_Nendomatu[nenrei - MIN_IZOKU_KO_JUKYU].ninzu = buffer[counter + 3];
								break;
							case 1 :
								Izoku_Ko_Nendomatu[nenrei - MIN_IZOKU_KO_JUKYU].kihon = buffer[counter + 3];
								break;
							case 2 :
								Izoku_Ko_Nendomatu[nenrei - MIN_IZOKU_KO_JUKYU].kakyu = buffer[counter + 3];
								break;
						}
					}
				}
			}
			else
			{
				readkisosu_error( 11 );
			}
		}
	}
	
	// PQDǕw
	for( nenrei = MIN_KAFU_JUKYU ; nenrei <= MAX_KAFU_JUKYU ; nenrei++ )
	{
		Kafu_Nendomatu[nenrei - MIN_KAFU_JUKYU].ninzu = 0.;
		Kafu_Nendomatu[nenrei - MIN_KAFU_JUKYU].noufu = 0.;
		Kafu_Kyu_Nendomatu[nenrei - MIN_KAFU_JUKYU].ninzu = 0.;
		Kafu_Kyu_Nendomatu[nenrei - MIN_KAFU_JUKYU].noufu = 0.;
		for( dankai = 0 ; dankai <= MAX_MENJO - 1 ; dankai++ )
		{
			for( kokko = 0 ; kokko <= KOKKO_HIKIAGE - 1 ; kokko++ )
			{
				Kafu_Nendomatu[nenrei - MIN_KAFU_JUKYU].menjo[dankai][kokko] = 0.;
				Kafu_Kyu_Nendomatu[nenrei - MIN_KAFU_JUKYU].menjo[dankai][kokko] = 0.;
			}
		}
	}
	
	if( shubetu == 2 )
	{
		for( nenrei = MIN_KAFU_JUKYU ; nenrei <= 69 ; nenrei++ )
		{
			if( read_data( buffer , fp_kisosu , &data_number ) != EOF )
			{
				if( buffer[0] != 12 )
				{
					cout << "ǕwN̓ǍɍsĂ܂" << buffer[0] << endl;
					exit( 1 );
				}
				else
				{
					if( nenrei <= 64 )
					{
						for( counter = 0 ; counter <= 13 ; counter++ )
						{
							switch( counter )
							{
								case 0 :
									Kafu_Kyu_Nendomatu[nenrei - MIN_KAFU_JUKYU].ninzu = buffer[counter + 3];
									break;
								case 1 :
									Kafu_Kyu_Nendomatu[nenrei - MIN_KAFU_JUKYU].noufu = buffer[counter + 3];
									break;
								case 2 :
									Kafu_Kyu_Nendomatu[nenrei - MIN_KAFU_JUKYU].menjo[ZENGAKU][1] = buffer[counter + 3];
									break;
								case 3 :
									Kafu_Nendomatu[nenrei - MIN_KAFU_JUKYU].ninzu = buffer[counter + 3];
									break;
								case 4 :
									Kafu_Nendomatu[nenrei - MIN_KAFU_JUKYU].noufu = buffer[counter + 3];
									break;
								case 5 :
									Kafu_Nendomatu[nenrei - MIN_KAFU_JUKYU].menjo[ZENGAKU][1] = buffer[counter + 3];
									break;
								case 6 :
										Kafu_Nendomatu[nenrei - MIN_KAFU_JUKYU].menjo[MENJO_3_4][1] = buffer[counter + 3];
									break;
								case 7 :
									Kafu_Nendomatu[nenrei - MIN_KAFU_JUKYU].menjo[MENJO_1_2][1] = buffer[counter + 3];
									break;
								case 8 :
									Kafu_Nendomatu[nenrei - MIN_KAFU_JUKYU].menjo[MENJO_1_4][1] = buffer[counter + 3];
									break;
								case 9 :
									Kafu_Kyu_Nendomatu[nenrei - MIN_KAFU_JUKYU].menjo[ZENGAKU][2] = buffer[counter + 3];
									break;
								case 10 :
									Kafu_Nendomatu[nenrei - MIN_KAFU_JUKYU].menjo[ZENGAKU][2] = buffer[counter + 3];
									break;
								case 11 :
										Kafu_Nendomatu[nenrei - MIN_KAFU_JUKYU].menjo[MENJO_3_4][2] = buffer[counter + 3];
									break;
								case 12 :
									Kafu_Nendomatu[nenrei - MIN_KAFU_JUKYU].menjo[MENJO_1_2][2] = buffer[counter + 3];
									break;
								case 13 :
									Kafu_Nendomatu[nenrei - MIN_KAFU_JUKYU].menjo[MENJO_1_4][2] = buffer[counter + 3];
									break;
							}
						}
					}
				}
			}
			else
			{
				readkisosu_error( 12 );
			}
		}
	}
	
	// PRDVbNiꕔJグҁj
 	for( nenrei = MIN_ROREI_JUKYU ; nenrei <= MAX_ROREI_JUKYU ; nenrei++ )
	{
		for( jukyu_nenrei = MIN_ROREI_JUKYU ; jukyu_nenrei <= 70 ; jukyu_nenrei++ )
		{
			Rorei_Ichibu_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].ninzu = 0.;
			Rorei_Ichibu_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].noufu = 0.;
			for( dankai = 0 ; dankai <= MAX_MENJO - 1 ; dankai++ )
			{
				for( kokko = 0 ; kokko <= KOKKO_HIKIAGE - 1 ; kokko++ )
				{
					Rorei_Ichibu_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].menjo[dankai][kokko] = 0.;
				}
			}
			Rorei_Ichibu_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].rofuku_shitasasae = 0.;
			Rorei_Ichibu_Nendomatu[nenrei - MIN_ROREI_JUKYU][jukyu_nenrei - MIN_ROREI_JUKYU].fuka = 0.;
		}
	}
	
	if( shubetu == 2 || shubetu == 5 )
	{
		for( member = 1 ; member <= 12 ; member++ )
		{
			for( nenrei = MIN_ROREI_JUKYU ; nenrei <= MAX_ROREI_JUKYU ; nenrei++ )
			{
				if( read_data( buffer , fp_kisosu , &data_number ) != EOF )
				{
					if( buffer[0] != 13 || buffer[1] != member )
					{
						cout << "VbN̓ǍɍsĂ܂ " << buffer[0] << " " << buffer[1] << " " << member << " " << buffer[3] <<  endl;
						exit( 1 );
					}
					else
					{
						for( counter = 0 ; counter <= 4 ; counter++ )
						{
							switch( member )
							{
								case 1 :
									Rorei_Ichibu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].ninzu = buffer[counter + 3];
									break;
								case 2 :
									Rorei_Ichibu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].noufu = buffer[counter + 3];
									break;
								case 3 :
									Rorei_Ichibu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].menjo[ZENGAKU][1] = buffer[counter + 3];
 									break;
								case 4 :
									Rorei_Ichibu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].menjo[MENJO_3_4][1] = buffer[counter + 3];
 									break;
								case 5 :
									Rorei_Ichibu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].menjo[MENJO_1_2][1] = buffer[counter + 3];
 									break;
								case 6 :
									Rorei_Ichibu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].menjo[MENJO_1_4][1] = buffer[counter + 3];
 									break;
								case 7 :
									Rorei_Ichibu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].rofuku_shitasasae = buffer[counter + 3];
									break;
								case 8 :
									Rorei_Ichibu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].fuka = buffer[counter + 3];
									break;
								case 9 :
									Rorei_Ichibu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].menjo[ZENGAKU][2] = buffer[counter + 3];
 									break;
								case 10 :
									Rorei_Ichibu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].menjo[MENJO_3_4][2] = buffer[counter + 3];
 									break;
								case 11 :
									Rorei_Ichibu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].menjo[MENJO_1_2][2] = buffer[counter + 3];
 									break;
								case 12 :
									Rorei_Ichibu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].menjo[MENJO_1_4][2] = buffer[counter + 3];
 									break;
							}
						}
					}
				}
				else
				{
					readkisosu_error( 13 );
				}
			}
		}
	}
	else if( shubetu == 3 || shubetu == 6 )
	{
		for( nenrei = MIN_ROREI_JUKYU ; nenrei <= MAX_ROREI_JUKYU ; nenrei++ )
		{
			if( read_data( buffer , fp_kisosu , &data_number ) != EOF )
			{
				if( buffer[0] != 13 || buffer[1] != 2 )
				{
					cout << "VbN̓ǍɍsĂ܂ " << buffer[0] << " " << buffer[1] << " " << member << " " << buffer[3] <<  endl;
					exit( 1 );
				}
				else
				{
					for( counter = 0 ; counter <= 4 ; counter++ )
					{
						Rorei_Ichibu_Nendomatu[nenrei - MIN_ROREI_JUKYU][counter].noufu = buffer[counter + 3];
					}
				}
			}
			else
			{
				readkisosu_error( 13 );
			}
		}
	}
	fclose(fp_kisosu);
	
	// Sꎞ̈̃NA
	for( nenrei = MIN_HIHO_NENREI ; nenrei <= MAX_HIHO_NENREI ; nenrei++ )
	{
		Ichijikin_Nendomatu[nenrei - MIN_HIHO_NENREI].ninzu = 0.;
		Ichijikin_Nendomatu[nenrei - MIN_HIHO_NENREI].kyufu = 0.;
		Ichijikin_Nendomatu[nenrei - MIN_HIHO_NENREI].kyufu_fuka = 0.;
	}
}


void readkisosu_error( int shurui )
{
	using namespace std;
	
	cout << "bt@Cǂݍݒɂdneo܂B bނ́A" << shurui << endl;
	exit(1);
}
